@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('style')
<style>
	.mailbox-attachments li{
		width:32%;
	}
	li .mailbox-attachment-icon{
		height: 172px;
	}
</style>
@endsection

@section('content')
	
	
	<div class="col-md-8 col-md-offset-0">
          <div class="box box-primary">
            <div class="box-header with-border  bg-aqua">
              <h3 class="box-title"> Situation du jour [ <a title="cliquez ici pour avoir la liste de tous les eleves inscrits" href="{{route('scholar.eleves.inscrits')}}" style="color:#FFF">{{$nombre_inscrit}} inscrits aujourd'hui </a>] {{ gethostbyaddr($_SERVER['REMOTE_ADDR'])}} </h3>

            </div>
            <!-- /.box-header -->
            <div class="box-body no-padding">
						@if(Session::has('error'))
						<div class="alert alert-danger alert-dismissible">
                <h4><i class="icon fa fa-ban"></i> Erreur!</h4>
								Classe non trouvee sur cette ligne <br>
								[{{ implode(", ",Session::get('error')) }}]
								<br>
								<b>
								1. Supprimer toutes les lignes au dessus de celle-ci <br>
								2. Corrigez le nom de la classe sur cette ligne<br>
								3. et renvoyez de nouveau le fichier</b>
              </div>
						
						@endif
              <img style="width: 98%;margin: auto;display: block;" src="{{asset('img/insc1.jpeg')}}" alt="Attachment">
            </div>
          </div>
          <!-- /. box -->
        </div>
	@php 
		$tabIdsClas=[];
		$user_c = App\User::find(\Auth::user()->id);
	@endphp

	@if($user_c->user_acces_to_zone('MENU-EFFECTIF-MSHC'))
		@foreach($msClasses as $sec=>$cls)
		@php 
			foreach($cls as $cl){$tabIdsClas[]=$cl->id;}
		@endphp
		@endforeach
		@php
			$nbr_eleve_sec = isset($msEleves['Secondaire'])?$msEleves['Secondaire']->count():0;
			$nbr_eleve_pri = isset($msEleves['Primaire'])?$msEleves['Primaire']->count():0;
			$nbr_eleve_mat = isset($msEleves['Maternelle'])?$msEleves['Maternelle']->count():0;
			$nbr_eleve_tot = $nbr_eleve_sec + $nbr_eleve_pri + $nbr_eleve_mat;
			
			$nbr_classe_sec = isset($msClasses['Secondaire'])?$msClasses['Secondaire']->count():0;
			$nbr_classe_pri = isset($msClasses['Primaire'])?$msClasses['Primaire']->count():0;
			$nbr_classe_mat = isset($msClasses['Maternelle'])?$msClasses['Maternelle']->count():0;
		@endphp
		<div class="col-md-4">
		<div class="info-box bg-aqua">
			<span class="info-box-icon"><i class="glyphicon glyphicon-education"></i></span>

			<div class="info-box-content">
			<span class="info-box-text"><a style="color:#FFF" href="{{route('scholar.effectifs')}}" >Effectifs de toute l'école</a></span>
			<span class="info-box-number">{{$nbr_eleve_tot }} élèves</span>

			<div class="progress">
				<div class="progress-bar" style="width: 100%"></div>
			</div>
			<span class="progress-description">
					<a style="color:#FFF" title="afficher toutes les classe de l'ecole" href="{{route('scholar.classes')}}">{{$nbr_classe_sec + $nbr_classe_mat + $nbr_classe_pri }} Classes
				</a>
				</span>
			</div>
			<!-- /.info-box-content -->
		</div>
		<hr style="border-top: 2px solid #000;"/>
		
		
		<div class="info-box bg-yellow">
			<span class="info-box-icon"><i class="glyphicon glyphicon-education"></i></span>

			<div class="info-box-content">
			<span class="info-box-text">Effectif Secondaire</span>
			<span class="info-box-number">{{$nbr_eleve_sec }} élèves</span>

			<div class="progress">
				<div class="progress-bar" style="width: {{divise(($nbr_eleve_sec*100),$nbr_eleve_tot)}}%"></div>
			</div>
			<span class="progress-description">
			{{$nbr_classe_sec}} Classes
			</span>
			</div>
			<!-- /.info-box-content -->
		</div>
		<!-- /.info-box -->
		<div class="info-box bg-green">
			<span class="info-box-icon"><i class="glyphicon glyphicon-education"></i></span>

			<div class="info-box-content">
			<span class="info-box-text">Effectif Primaire</span>
			<span class="info-box-number">{{ $nbr_eleve_pri }} élèves</span>

			<div class="progress">
				<div class="progress-bar" style="width: {{divise(($nbr_eleve_pri*100),$nbr_eleve_tot)}}%"></div>
			</div>
			<span class="progress-description">
			{{$nbr_classe_pri}} Classes
			</span>
			</div>
			<!-- /.info-box-content -->
		</div>
		<!-- /.info-box -->
		<div class="info-box bg-red">
			<span class="info-box-icon"><i class="glyphicon glyphicon-education"></i></span>

			<div class="info-box-content">
			<span class="info-box-text">Effectif Maternelle</span>
			<span class="info-box-number">{{$nbr_eleve_mat }} élèves</span>

			<div class="progress">
				<div class="progress-bar" style="width: {{divise(($nbr_eleve_mat*100),$nbr_eleve_tot)}}%"></div>
			</div>
			<span class="progress-description">
			{{$nbr_classe_mat}} Classes
			</span>
			</div>
			<!-- /.info-box-content -->
		</div>
		<!-- /.info-box -->
		<div class="box box-primary y collapsed-box">
			<div class="box-header with-border bg-aqua">
			<h3 class="box-title">Imports & Exports</h3>

			<div class="box-tools pull-right">
				<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
			</div>
			</div>
			<!-- /.box-header -->
			
			<div class="box-body" style="display:none">
			<ul class="products-list product-list-in-box">
				<li class="item">
				<div class="product-img">
					<i class="fa fa-cloud-download text-maroon" style="font-size: 35px;text-align: center;"></i>
				</div>
				<div class="product-info" style="margin-left: 47px;">
					<a href="javascript:void(0)" class="product-title" id="download-grille-classe">Telecharger la grille des promotions</a>
					<span class="product-description">puis indiquez les noms des classes organisees</span>
				</div>
				</li>
				<li class="item">
				<div class="product-img">
					<i class="fa fa-cloud-upload text-olive" style="font-size: 35px;text-align: center;"></i>
				</div>
				<div class="product-info" style="margin-left: 47px;">
					<a href="javascript:void(0)" class="product-title"><label for="input-classes-select" style="margin: 0;">
						Uploader la grille des promotions
					</label></a>
					
					<span class="product-description">pour mettre a jour la liste des classes dans le systeme</span>
				</div>
				</li>
			
				<li class="item">
				<div class="product-img">
					<i class="fa fa-cloud-download text-maroon" style="font-size: 35px;text-align: center;"></i>
				</div>
				<div class="product-info" style="margin-left: 47px;">
					<a href="javascript:void(0)" class="product-title" id="download-grille-eleves">Telecharger la grille des élèves</a>
					<span class="product-description">puis indiquez les élèves par classe</span>
				</div>
				</li>
				<li class="item">
				<div class="product-img">
					<i class="fa fa-cloud-upload text-olive" style="font-size: 35px;text-align: center;"></i>
				</div>
				<div class="product-info" style="margin-left: 47px;">
					<a href="javascript:void(0)" class="product-title"><label for="input-eleve-select" style="margin: 0;">
						Uploader la grille des élèves
					</label></a>
					
					<span class="product-description">pour mettre a jour la liste des élèves dans le systeme</span>
				</div>
				</li>
			
			</ul>
			</div>
		</div>
		</div>
		<a href="#" download='ch' style="display:none" id="link-download-grille-cote">Download</a>

		<form enctype="multipart/form-data" style='display:none' id="form4" action="{{route('scholar.import.classes')}}" method="POST">
			{{csrf_field()}}
			<input  name="select_file" id="input-classes-select" type="file" style="display:none;" />
		</form>
		<form enctype="multipart/form-data"  class="form-horizontal"  id="form-eleve" method="POST" action="{{route('scholar.eleves.import')}}" >
			{{csrf_field()}}
			<input  name="select_file[]" multiple id="input-eleve-select" type="file" style="display:none;padding: 0px;" />
		</form>
	@endif	
		
@endsection

@section('script')
	
	
<script>

	@if($user_c->user_acces_to_zone('MENU-EFFECTIF-MSHC'))
		
		function download_grille_classes(){
			var url = "{{route('scholar.export.promotions')}}";
			
			var link = document.getElementById("link-download-grille-cote");
			link.setAttribute('href',url);
			link.click();
			alert('La grille des classes a été téléchargée');	
		}
		
		function download_grille_eleve(){
			var url = "{{asset('export/grille/vide/eleves/')}}";		
			var link = document.getElementById("link-download-grille-cote");
			
			var tab = [ {{implode(',',$tabIdsClas)}} ];
			for(i in tab){
				id = tab[i];
				href = url+'/'+id;
				console.log( href );
				// 
				link.setAttribute('href',href);
				link.click();
			}
			var msg = 'Toutes les grilles ont été téléchargées';
			alert(msg);		
		}
		
		$(function(){
			$("#download-grille-classe").click(function(){
				download_grille_classes();
			})
			$("#download-grille-eleves").click(function(){
				download_grille_eleve();
			})
			
			$("label[for='input-eleve-select']").click(function(){
				$("#input-eleve-select").val('');
			})
			$("#input-eleve-select").change(function(){
				var grille = $("#input-eleve-select").val();
				if(grille){
					if(confirm('Voulez-vous envoyer les fichier selectionnés ?'))
						document.getElementById('form-eleve').submit();
					else alert("Envoi annulé");
				}
				//else alert('Selectionnez la grille SVP!');
			})
			$("label[for='input-classes-select']").click(function(){
				$("#input-classes-select").val('');
			})
			$("#input-classes-select").change(function(){
				var grille = $("#input-classes-select").val();
				if(grille){
					if(confirm('Voulez-vous envoyer les fichier selectionnés ?'))
						document.getElementById('form4').submit();
					else alert("Envoi annulé");
				}
				//else alert('Selectionnez la grille SVP!');
			})
		})
			
	@endif		
	
</script>	
	
@endsection