@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('content')


<div class="row">
		<div class="col-xs-12 col-xs-offset-0" style="margin-right:3%;margin-left:3%;width: 94%;">
          <div class="box">
            <div class="box-header">
              	<h3 style="margin: 0;">
								{{ \App\Config::getEcole()}} Classement	en {{ \App\Config::getAnnee()}}
								</h3>
              
            </div>
            <!-- /.box-header -->
            <div class="box-body table-responsive no-padding">
            @php display_flash() @endphp
							
						<table class="table table-striped table-bordered table-condensed table-hover">
								<thead>
										<tr>					
											<th></th>
											<th>Promotion</th>
											<th>Option</th>
											<th>Section</th>
											<th>Nbre. Inscrits</th>
											<th>Nbre. Elèves Classés</th>
											<th>Nbre. Classes</th>
											<td>Actions</td>
											<td>Voir</td>
										</tr>
								</thead>
								<tbody>
								@foreach($mspromotions as $key => $value)
									<tr>
										<td>{{$loop->index+1}}</td>
										<td>{{ $value->promotion }}</td>
										<td>{{ $value->option }}</td>
										<td>{{ $value->section->nom_sec }}</td>
										<td class="text-center">{{ count($value->msInscriptions) }}</td>
										<td class="text-center">{{ $value->msInscriptions->sum(function ($insc) {  return $insc->msEleves->count(); }) }}</td>
										<td class="text-center">{{ count($value->msClasses) }}</td>

											<!-- we will also add show, edit, and delete buttons -->
										<td>

											<a class="btn btn-small btn-info btn-xs" 
												href="{{ route( 'payment.classer.eleves', ['promotion'=>$value->id] ) }}">Repartir</a>
										</td>
										<td>
											<a class="btn btn-small btn-success btn-xs" title="Voir les élève de la promotion" 
												href="{{ route( 'payment.promotion.eleves', ['promotion'=>$value->id] ) }}">
												Voir Elèves</a>

										</td>
									</tr>
								@endforeach
								</tbody>
						</table>
						
						</div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
    </div>
</div>
				
@endsection 