@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
	.select2-container--default .select2-selection--single {
		min-height: 34px;
	}
	#content-list .content, #content-list ,#content-list .col-md-12 {
	padding: 0;
	}
	</style>
@endsection
@section('content')
<div class="col-md-12 col-md-offset-0">

	<form enctype="multipart/form-data"  class="form-horizontal no-print"  id="form-paiement-frais" method="POST" action="{{route('scholar.eleves.classe')}}" >
		<div class=" col-sm-12" style="margin-bottom: 20px;">
		{{csrf_field()}}
		@php 
			$classe_id = isset($_POST['ms_classe_id'])?$_POST['ms_classe_id']:(isset($_GET['ms_classe_id'])?$_GET['ms_classe_id']:0);
		@endphp
			<div class="col-sm-3" style="padding-left: 0px;">
				<select name="ms_classe_id" id="input-ms_classe_id-id" class="form-control select2" style="width: 100%">
					<option value="all">Choisir une classe</option>
					@foreach($msClasses as $e)
						<option {{ $classe_id==$e->id?'selected':''}} value="{{$e->id}}">{{$e->classe.' '.$e->msPromotion->promotion.' '.$e->msPromotion->section->nom_sec}}</option>
					@endforeach
				</select>
				
			</div>
			<div class="col-sm-3" style="">
				<label>Afficher les image <input type="checkbox" name="img_enfant" value="1"/></label>
			</div>
			<div class="col-sm-2" style="">
				<button type="submit" class="btn btn-info ">Voir Elèves</button>
			</div>
			
			@if(isset($_POST['img_enfant']))
			<div class="col-sm-3" style="">
				<label>Confirmer l'image <input type="checkbox" id="confiermer-envoi" value="1"/></label>
			</div>
			@endif
			<!--div class="col-sm-4" style="">
				<input  name="select_file[]" class="form-control" multiple id="input-mois-id" type="file" style="padding: 0px;" />
			</div>
			<div class="col-sm-2" style="padding-right: 0px;">
				<button type="reset" class="btn btn-danger pull-right">Annuler</button>
				<button type="submit" class="btn btn-info pull-right " title='Importer les eleves dans la classe' >Importer</button>
			</div-->
		</div>
	</form>
	
	<div class="col-md-12" >
		<div class="box no-border" style="padding: 0 10px;">
			<div class="box-header no-print">
				<h3 class="box-title">Liste des élèves de 
					<b>{{$classe?($classe->classe.' '.$classe->msPromotion->promotion.' '.$classe->msPromotion->section->nom_sec):''}}</b>
					Année Scolaire <b>{{ \App\Config::getAnnee()}}</b>
				</h3>
				<div class="box-tools">                
				@include('partials.btn_group_export',['jsSelector'=>"#table_liste_eleve",'app'=>'Scholar'])						
				</div>
			</div>
			<div class="box-header my_title" style="text-align: center;display:none">
				<h3 class="box-title" style="width:100%;text-align:left">
				
					<img style="" src="{{ \App\Config::getLogo()?asset('storage/ecole/logo_ecole/'.\App\Config::getLogo())
									:asset('img/logo.png') }}" alt="logo"/>
				
					<span>ECOLE </span>: <b>{{\App\Config::getEcole()}}</b><br/>
					<span>CLASSE </span>: <b>{{$classe->classe??''}}</b> / Section  <b>{{$classe->msPromotion->section->nom_sec??''}}</b><br/>
					<span>ANNEE SCOLAIRE </span>: <b>{{\App\Config::getAnnee()}}</b>
					
					<div style="position: relative;"> <div style="position: absolute;width:100%;border:solid 24px #3c8dbc6b;height:0px !important;">&nbsp;</div> <p> LISTE DES ELEVES </p></div>	
				</h3>
				<p style="position: relative;top: 20px;font-size: 18px;color: #3c8dbc;font-style: italic;">
				@php 
				$nbr_r = $nbr_f = $nbr_g = 0;
					$nbr_t = count($msEleves);
					if($nbr_t){
						$stat = collect($msEleves)->groupBy(function ($item, $key) {
							return $item->enfant->genre;
						});
						$nbr_f = isset($stat['F'])?$stat['F']->count():0;
						$nbr_g = isset($stat['M'])?$stat['M']->count():0;
						$nbr_r = $nbr_t - $nbr_f -$nbr_g;
					}
				@endphp
				Nombre des Fille: <b>{{$nbr_f}}</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				Nombre des Garcon: <b>{{$nbr_g}}</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				@if($nbr_r)
				Autre: <b>{{$nbr_r}}</b>
				@endif
				</p>
			</div>
			<!-- /.box-header -->
			<div class="box-body no-padding table-responsive" id="table_liste_eleve">
			
				<form class="form-horizontal hide" id="form-edit-img-eleve" action="{{route('scholar.update.insc.image.brute')}}" method="POST" enctype="multipart/form-data">
					{{csrf_field()}}
					<input  name="img_enfant" id="input-img_enfant-id" type="file"> 
					<input  name="ms_inscription_id" id="input-ms_inscription_id-id" type="hidden"> 
					
				</form>
				<table id="datatable-mseleves" class="table editable-table table-striped table-bordered table-condensed">
					@if(isset($_POST['img_enfant']))
					<thead>
							<tr>
								
								<th>Num</th>
								<th></th>
								<th>Identite</th>
								<th>Classe</th>
								<th>Tuteur</th>
								<th  class="no-print">Dossier</th>
								<th class="no-print"> <a href="#x" id="remerciements"> <i class="fa-send fa"></i> SMS</a></th>
							</tr>
					</thead>
					<tbody>
					@foreach($msEleves as $key => $mseleve)
							<tr>								
								<td>{{$loop->index+1}}</td>
								<td>
									<div style="position: relative;">
									<label style="position: relative;height: 75px;overflow:hidden" title="Cliquez ici pour modifier l'image" class="edit-img" for="input-img_enfant-id" idins="{{$mseleve->id}}">
									<img src="{{$mseleve->img_enfant?asset('storage/msinscription/img_enfant/'.$mseleve->img_enfant):asset('img/users25.png')}}" 
									style="width: 100px;" alt="User Image" id="img-eleve-{{$mseleve->id}}">
									<span style="position: absolute;left: 0;" class="fa fa-edit no-print"></span></label>
									<div style="position: absolute;top:0;bottom:0;right:0;left:0" class="overlay hide"  id="img-overlay-{{$mseleve->id}}">
										<i class="fa fa-refresh fa-spin"></i>
									</div></div>
								</td>
								<td>
									<span class='editable-td' k='{{$mseleve->enfant->id}}' f='nom' i='1' t='text' >{{ $mseleve->enfant->nom}} </span> 
									<span class='editable-td' k='{{$mseleve->enfant->id}}' f='postnom' i='1' t='text' >{{ $mseleve->enfant->postnom}} </span> <br/>
									<i><span class='editable-td' k='{{$mseleve->enfant->id}}' f='prenom' i='1' t='text' >{{ trim($mseleve->enfant->prenom)?ucfirst(strtolower($mseleve->enfant->prenom)):'-'}} </span> </i><br/>
									<span class='editable-td' k='{{$mseleve->enfant->id}}' f='genre' i='1' t='text' >{{  $mseleve->enfant->genre}} </span> <br/>
									<b>{{$mseleve->enfant->matricule}}</b>
								</td>
								<td>
									<b>{{ $mseleve->msClasse->classe.' '.($mseleve->msClasse->msPromotion->section->nom_sec??'') }}</b> <br>
									Inscrit{{$mseleve->enfant->genre=='F'?'e':''}} le {{ date('d-M, Y',strtotime($mseleve->inscrit_le)) }} <br>
									{{ $mseleve->etat }}<br>
									{{ $mseleve->statusEnfant->status??'' }}
								</td>
								<td>
									<span class='editable-td' k='{{$mseleve->tuteur->id??''}}' f='nom_tuteur' i='3' t='text'>
									{{ ($mseleve->tuteur->nom_tuteur??'')}}</span> <br>
									<span class='editable-td' k='{{$mseleve->tuteur->id??''}}' f='telephone' i='3' t='text'>
									{{($mseleve->tuteur->telephone??'') }}</span>
								</td>
								

								{{--<td>
									<a href="{{route('scholar.carte',['ms_eleve_id'=>$mseleve->id])}}" class="btn btn-block btn-danger btn-xs btn-flat">Carte d'élève</a>
								</td> --}}
								<td class="no-print"> 
									<a href="{{route('scholar.dossier',['ms_eleve_id'=>$mseleve->id])}}" class="btn btn-block btn-success btn-xs btn-flat">Dossier</a>
								</td>
								<td class="no-print"><a href="#x" route="{{route('scholar.remerciement')}}?eleve_id={{$mseleve->id}}" class="remerciement" >Merci</a></td>
							</tr>
					@endforeach
					</tbody>
								
					@else
						<thead>
								<tr>
									
									<th>Num</th>
									<th>Matricule</th>
									<th>CODE</th>
									<th>Nom</th>
									<th>Postom</th>
									<th>Preom</th>
									<th>Genre</th>
									<th>Nom Tuteur</th>
									<th>Tel. Tuteur</th>
									<th>Date Inscription</th>
									<th>Etat</th>
									<th>Status</th>
									<th>Dossier</th>
									<th> <a href="#x" id="remerciements"> <i class="fa-send fa"></i> SMS</a></th>
								</tr>
						</thead>
						<tbody>
						@foreach($msEleves as $key => $mseleve)
							<tr>								
								<td>{{$loop->index+1}}</td>
								<td>{{$mseleve->enfant->matricule}}</td>
								<td>{{$mseleve->code_secret}}</td>
								<td>{{ $mseleve->enfant->nom}}</td>
								<td>{{ $mseleve->enfant->postnom}}</td>
								<td>{{ $mseleve->enfant->prenom}}</td>
								<td>{{ $mseleve->enfant->genre }}</td>
								<td class='editable-td' k='{{$mseleve->tuteur->id??''}}' f='nom_tuteur' i='3' t='text'>
									{{ ($mseleve->tuteur->nom_tuteur??'')}}
								</td>
								<td class='editable-td' k='{{$mseleve->tuteur->id??''}}' f='telephone' i='3' t='text'>
									{{($mseleve->tuteur->telephone??'') }}
								</td>
								<td class="editable-td" k='{{$mseleve->id??''}}' f='inscrit_le' i='8' t='date'>{{ $mseleve->inscrit_le }}</td>
								<td class="editable-td" k='{{$mseleve->id??''}}' f='etat' i='8' t='text'>{{ $mseleve->etat }}</td>
								<td>{{ $mseleve->statusEnfant->status??'' }}</td>

								{{--<td>
									<a href="{{route('scholar.carte',['ms_eleve_id'=>$mseleve->id])}}" class="btn btn-block btn-danger btn-xs btn-flat">Carte d'élève</a>
								</td> --}}
								<td> 
									<a href="{{route('scholar.dossier',['ms_eleve_id'=>$mseleve->id])}}" class="btn btn-block btn-success btn-xs btn-flat">Dossier</a>
								</td>
								<td><a href="#x" route="{{route('scholar.remerciement')}}?eleve_id={{$mseleve->id}}" class="remerciement" >Merci</a></td>
							</tr>
					@endforeach
					</tbody>
					@endif
				</table>
			</div>
			<div class="overlay hide form-overlay">
				<i class="fa fa-refresh fa-spin"></i>
			</div>
		</div>
	</div>
	
	
	</div>
@endsection
		
@section('script')
	@include("partials.export_js_files")
	<script src="{{asset('js/select2.full.min.js')}}"></script>
	
	<script>
	var TAB = [],INDICE=0;
		var ID = 0;
	$(function () {
		//Initialize Select2 Elements
		$('.select2').select2()

		function envoyer_a_tous_les_parent(){
			var link = TAB[INDICE++];
			if(link){
				console.log(link);
				link.innerHTML = 'envoi...';
				var url = link.getAttribute('route');
				$.get(url,function(data){
					if(data=='OK')
						link.innerHTML = ' <b style="color:green">OK</b> ';
					else {
						link.innerHTML = ' <b style="color:red">Echec</b> ';					
					}
					envoyer_a_tous_les_parent();
				})
			}			
		}
		$(".edit-img").click(function(){
			$("#input-img_enfant-id").val('');
			var id = $(this).attr("idins");
			ID = id;
			$("#input-ms_inscription_id-id").val(id);
		})
		
		$("#input-img_enfant-id").change(function(){
			$("#img-overlay-"+ID).removeClass('hide');
			$("#img-overlay-"+ID).show();
			if(!$("#confiermer-envoi").is(':checked'))
				$("#form-edit-img-eleve").submit();
			else if(confirm("Voulez-vous envoyer cette image ?"))
				$("#form-edit-img-eleve").submit();
			else $("#img-overlay-"+ID).hide();
		})
		
		function click_callback(){
			$("#img-overlay-"+ID).show();

			// $("#form-inscription-_token").val($("#lbl-inscription-_token").text());			
		}
	
		// fonction à exécuter après inscription 
		function success_callback_on_inscription(data, textStatus, jqXHR){
			$("#img-overlay-"+ID).hide();
			$("#form-btn-submit").removeClass('disabled');
			if(data.result=="success"){
				$("#img-eleve-"+data.id).attr("src",data.url);
			}
		}
	
		ajax_fomr_submit("#form-edit-img-eleve",success_callback_on_inscription, click_callback);
		
		$("#remerciements").click(function(){
			TAB = $(".remerciement");
			console.log(TAB);
			INDICE=0;
			envoyer_a_tous_les_parent();
		})
		$(".remerciement").click(function(){
			var link = $(this);
			$(this).text('envoi...');
			var url = $(this).attr('route');
			$.get(url,function(data){
				if(data=='OK')
					link.html(' <b style="color:green">OK</b> ');
				else {
					link.html(' <b style="color:red">Echec</b> ');
					alert(data);
				}
			})
		})
	})
	</script>
@endsection



