@extends("template")

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
@endsection

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('content')
<style>
.overlay{display:none}
.select2-selection.select2-selection--single {
    height: 34px;
    border-radius: 3px 0 0 3px;
}
#content-list{padding:0px}
</style>

<div class="row">
	<div class="col-xs-12 no-padding" style="">
		<div class="col-xs-6 col-xs-offset-0"  style="padding-left:0">
			<div class="box  collapsed-box" style="padding: 0 10px;">
				<div class="box-header">
					<h3 style="margin: 0;">
					CHANGE LA CLASSE DES ELEVES
					</h3>
					<div class="box-tools pull-right">
						<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
					</div>
				</div>
				<!-- /.box-header -->
				<div class="box-body table-responsive no-padding" style="display:none">
					<form  enctype="multipart/form-data" action="{{route('scholar.update.insc.classes')}}" method="post">
						{{csrf_field()}}
						<div class="col-sm-12 show-on-pc" style="background: #ecf0f5;padding: 10px;color: #3c8dbc;margin-bottom: 10px;">
							<label class="col-sm-2 control-label" style="text-align: left;padding-left: 0;margin-top: 7px;">
							ELEVES</label>
							
							<div class="col-sm-10" style="padding-right: 0;">
								
								<select multiple name="ms_inscriptions_id[]" id="liste-eleve-select" class="form-control"></select>

							</div>	
						</div>	
						<div class="col-sm-12 show-on-pc" style="background: #ecf0f5;padding: 10px;color: #3c8dbc;margin-bottom: 10px;">
							<label class="col-sm-2 control-label" style="text-align: left;padding-left: 0;margin-top: 7px;">
							CLASSE</label>
							
							<div class="col-sm-10" style="padding-right: 0;">
								
								<div class="input-group" style="">
								<select name="ms_classe_id" id="liste-classe-select" class="form-control"></select>
									<span class="input-group-btn">
										<button type="submit"  class="btn btn-success btn-flat">Changer 
											<i class="fa fa-edit"></i> </button>
									</span>
								</div>

							</div>	
						</div>
					</form>
				</div>
			</div>

		</div>
	
		<div class="col-xs-6 col-xs-offset-0" style="padding-right:0" >
			<div class="box  collapsed-box" style="padding: 0 10px;">
				<div class="box-header">
					<h3 style="margin: 0;">
					CHARGER LES RESULTATS DES TEST
					</h3>
					<div class="box-tools pull-right">
						<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
					</div>
				</div>
				<!-- /.box-header -->
				<div class="box-body table-responsive no-padding" style="display:none">
					
					<form  enctype="multipart/form-data" action="{{route('scholar.import.result.test')}}" method="post">
						{{csrf_field()}}
						<div class="col-sm-12 show-on-pc" style="background: #ecf0f5;padding: 10px;color: #3c8dbc;margin-bottom: 10px;">
							<label class="col-sm-5 control-label" style="text-align: left;padding-left: 0;margin-top: 7px;">
							INDIQUER LE FICHEIR</label>
							
							<div class="col-sm-7" style="padding-right: 0;">
								
								<div class="input-group" style="display:">
								<input type="file" name="select_file" id="" class="form-control">
									<span class="input-group-btn">
										<button type="submit"  class="btn btn-success btn-flat">Envoyer <i class="fa fa-send"></i> </button>
										<span class="glyphicon glyphicon-ok"></span> Payé.</button>
									</span>
								</div>

							</div>	
						</div>
					</form>
				</div>
			</div>

		</div>
	</div>
</div>

<div class="row">
		<div class="col-xs-12 no-padding" style="">
          <div class="box" style="padding: 10px;">
            <div class="box-header">
              	<h3 style="margin: 0;">
					ELEVES INSCRITS	en <b>{{ \App\Config::getAnnee()}}</b>
				</h3>
              
            </div>
            <!-- /.box-header -->
            <div class="box-body table-responsive no-padding">

				
			
				<form style="display:none" enctype="multipart/form-data" action="{{route('scholar.image.result.test')}}" id="form-send-test-copy" method="post">
					{{csrf_field()}}
					<input type="hiddenn" name="ms_inscription_id" id="ms_inscription_id" value="" >
					<input type="file" name="copie_test" id="link-preuve-test" class="form-control">
					<input type="file" name="copie_test1" id="link-preuve-test1" class="form-control">
					<button type="submit"  class="btn btn-success btn-flat">Envoyer <i class="fa fa-send"></i> </button>					
				</form>
				@if(Session::has('error'))
					<div class="alert alert-danger alert-dismissible">
                		<h4><i class="icon fa fa-ban"></i> Erreur!</h4>
							<p>Veuillez corriger les matricules des eleves suivants en suite rechargez les cotes</p> <br>
							{!! implode(", <br/> ",Session::get('error')) !!}
              		</div>
						
				@endif
              	<table class="table table-striped table-hover table-bordered table-condensed editable-table" id="liste-eleve" >
						<thead>
								<tr>
									
									<th>N°</th>
									<th>Matricule</th>
									<th>Noms</th>
									<th>Promotion</th>
									<th>Date Inscription</th>
									<th>Montant Payé</th>
									<th>Tuteur/Tutrice</th>
									<th>Recu</th>
									<th>(%)</th>
									<th>P-1</th>
									<th>P-2</th>
									<th>
									<form id="" class="form-horizontal"  onsubmit="return confirm('Voulez-vous vider toute la base de donnees ?')" action="{{route('scholar.vider.tables')}}" method="POST" >
									<input type="submit" id="supperimer-all-tables" value="" style="display:none">
									<label for="supperimer-all-tables"><i class='glyphicon glyphicon-trash text-red'></i></label>
									<input type="hidden" name="_token" value="{{csrf_token()}}" id="form-inscription-_token" />
									</form>
									</th>
								</tr>
						</thead>
						<tbody>
						
						</tbody>
				</table>
            </div>
			<div class="overlay" style=""> <i class="fa fa-refresh fa-spin"></i> </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
    </div>
</div>

<div class="modal modal-danger fade" id="modal-supprimer-insc">
	<div class="modal-dialog">
	<div class="modal-content" id="modal-supprimer-insc-body" >
		
	</div>
	<!-- /.modal-content -->
	</div>
	<!-- /.modal-dialog -->
</div>
<!-- /.modal -->
@endsection
					
@section('script')
<script src="{{asset('js/select2/select2.full.js?p=y')}}"></script>
<script type="text/javascript" language="javascript" >
$(document).ready(function(){
	$('#liste-eleve-select').select2({
		  placeholder: "Indiquez les nom des enfant dont il faut changer de classe svp!",
		  allowClear: true,
		  minimumInputLength: 2,
		  ajax: {
				url: "{{route('scholar.select.inscription.ajax')}}",
				dataType:"json",
				processResults: function (data) {
					// Transforms the top-level key of the response object from 'items' to 'results'
					return {
					results: data.items
					};
				}
		  }
	});
	
	$('#liste-classe-select').select2({
		  placeholder: "Indiquez une classe svp!",
		  //allowClear: true,
		  //minimumInputLength: 2,
		  ajax: {
				url: "{{route('scholar.select.classe.ajax')}}",
				dataType:"json",
				processResults: function (data) {
					// Transforms the top-level key of the response object from 'items' to 'results'
					return {
					results: data.items
					};
				}
		  }
	});
	$('#link-preuve-test').change(function(){
		if(confirm("Voulez-vous Envoyer ce ficher ?"))
			$('#form-send-test-copy').submit();
	});
	
	$('#link-preuve-test1').change(function(){
		if(confirm("Voulez-vous Envoyer ce ficher ?"))
			$('#form-send-test-copy').submit();
	});
	
	$('#liste-eleve').on('click','.ms_inscription_id',function(){
		var id = $(this).attr('k');
		$('#ms_inscription_id').val(id);
	});
	
	$('#liste-eleve').on('click','.delete-insc',function(){
		var id = $(this).attr('k');
		var url = "{{route('scholar.supprimer.inscription')}}?ms_eleve_id="+id;
		$.get(url,function(html){
			$("#modal-supprimer-insc-body").html(html);
			$("#modal-supprimer-insc").modal("show");
		});
	});
	
	ajax_fomr_submit("#form-send-test-copy",function(data){
		$('.overlay').hide();
		if(!data.fail){
			$('#insc-'+data.id).parent().parent().attr("style","color:blue;font-weight:bolder");
		}
		else {
			$('#insc-'+data.id).parent().parent().attr("style","color:red");
			alert(data.msg);
		}
	}, function(){
		$('.overlay').show();
	});

 var dataTable = $('#liste-eleve').DataTable({
  "processing":true,
  "serverSide":true,
  "order":[],
  "ajax":{
   url:"{{route('scholar.eleves.inscrits')}}/true",
   type:"GET"
  }
  ,
  "createdRow": function( row, data, dataIndex ) {
	  var id = $('td:eq(7)', row).text();
	  var b = ' <i class="fa fa-print"  title="Imprimer le reçu d\'inscription" onclick="recuInscription('+id+')" ></i>';
	  $('td:eq(7)', row).html(b );
	  $('td:eq(7)', row).attr('style','padding:3px;text-align: center;' );
	  $('td:eq(8)', row).html("<label class='editable-td' k='"+id+"' f='test_pourcentage' i='10' t='text'>"+data[8]+"</label>" );
	  var src = "{{asset('storage/msinscription/copie_test/')}}/"+data[9];
	  var src1 = "{{asset('storage/msinscription/copie_test1/')}}/"+data[10];
	  $('td:eq(9)', row).html("<label id='insc-"+id+"' class='ms_inscription_id' for='link-preuve-test' k='"+id+"' title='Ajouter le corrigé du test' ><i class='glyphicon glyphicon-"+(data[9]?'pencil':'plus')+"'></i></label> "+(data[9]?"<a target='_blanck' href='"+src+"'> <i class='glyphicon glyphicon-eye-open'></i> </a>  <!--img src='"+src+"' style='height:40px'-->":'')+"" );
	  $('td:eq(10)', row).html("<label class='ms_inscription_id' for='link-preuve-test1' k='"+id+"' title='Ajouter un autre corrigé du test' ><i class='glyphicon glyphicon-"+(data[10]?'pencil':'plus')+"'></i></label> "+(data[10]?"<a target='_blanck' href='"+src1+"'>Voir</a> <!--img src='"+src1+"' style='height:40px'-->  ":'')+"" );
	  $('td:eq(11)', row).html("<label class='delete-insc text-red' k='"+id+"' ><i class='glyphicon glyphicon-trash'></i></label> "+(data[10]?"<a target='_blanck' href='"+src1+"'>Voir</a> <!--img src='"+src1+"' style='height:40px'-->  ":'')+"" );
	  
  }

 });
});
 </script>
@endsection